﻿using System;

// Listing 3-42. Stan statyczny
public class MyClassWithAStaticProperty
{
    public static bool TrueOrFalse
    {
        get;
        set;
    }
    public void SayWhetherTrueOrFalse()
    {
        Console.WriteLine("Wartość w obiekcie {0}.", TrueOrFalse);
    }
}
class Program
{
    static void Main(string[] args)
    {
        // Tworzymy dwa obiekty.
        MyClassWithAStaticProperty object1 = new MyClassWithAStaticProperty();
        MyClassWithAStaticProperty object2 = new MyClassWithAStaticProperty();

        // Sprawdzamy wartości właściwości w obu obiektach
        // oraz w przypadku odwołania się do nich przez klasę.
        object1.SayWhetherTrueOrFalse(); object2.SayWhetherTrueOrFalse();
        Console.WriteLine("Wartość w klasie {0}.",
        MyClassWithAStaticProperty.TrueOrFalse);

        // Zmieniamy wartość.
        MyClassWithAStaticProperty.TrueOrFalse = true;

        // i sprawdzamy, czy wszędzie się zmieniła.
        object1.SayWhetherTrueOrFalse();
        object2.SayWhetherTrueOrFalse();
        Console.WriteLine("Wartość w klasie: {0}.",
        MyClassWithAStaticProperty.TrueOrFalse);
        Console.ReadKey();
    }
}